<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template name="createMethodSummaryTable">
		<xsl:param name="title"/>
		<xsl:param name="nodeSet"/>
		<xsl:param name="classpath"/>
		<a name="method_summary"></a>
		<table border="1" cellpadding="3" cellspacing="0" width="100%">
			<tr class="TableHeaderStyle">
				<td colspan="2">
					<font size="+2">
						<b>
							<xsl:value-of select="$title"/>
						</b>
					</font>
				</td>
			</tr>
			<xsl:for-each select="$nodeSet">
				<xsl:sort select="@name" />

				<!-- Define variables -->
				<xsl:variable name="description">
					<xsl:apply-templates select="current()" mode="getDescription"/>
				</xsl:variable>
				<xsl:variable name="elName" select="@name"/>
				<xsl:variable name="inner-ref">
					<xsl:apply-templates select="current()" mode="method-ref"></xsl:apply-templates>
				</xsl:variable>
				
				<tr class="TableRow">

					<!-- Print method return value -->
					<td align="right" valign="top" width="20%">
						<xsl:variable name="typeName">
							<xsl:call-template name="typeRefHandler">
								<xsl:with-param name="parameter" select="current()/ReturnType"></xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<font size="-1"><code>
                                                &amp;nbsp; <xsl:value-of select="@visibility"/>
						<xsl:text> </xsl:text>

						<b>
						<xsl:choose>
							<xsl:when test="string-length(string($typeName)) &gt; 0">
								<xsl:if test="$prj_lang='delphi'">
									<xsl:text>function </xsl:text>
								</xsl:if>
								<xsl:value-of select="$typeName"/>
							</xsl:when>
							<xsl:when test="current()/@isSubroutine">
								<xsl:text>Sub </xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$prj_lang='csharp'">
										<xsl:text>void</xsl:text>
									</xsl:when>
									<xsl:when test="$prj_lang='delphi'">
										<xsl:text>procedure</xsl:text>
									</xsl:when>
									<xsl:otherwise>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						</b></code>
						</font>
					</td>
					<!-- Print method full name -->
					<td>
						<code><b>
							<a href="{$classpath}#{$inner-ref}">
								<xsl:value-of select="$elName"/>
							</a></b>
							<xsl:apply-templates select="current()" mode="method-parentheses"></xsl:apply-templates>						
						</code>
						<br/><xsl:text>&#x9;</xsl:text>
						<xsl:choose>
							<xsl:when test="string-length($description) &gt; 0">
								<xsl:value-of select="Property[@name='description']"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>&#xA0;</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
			</xsl:for-each>
		</table>
		<xsl:text>&#xA0;</xsl:text>
		<p/>
	</xsl:template>

	<!-- Creates inherited methods table -->
	<xsl:template name="InheritedMethods">
		<xsl:param name="class"></xsl:param>
		<xsl:param name="thisNode"></xsl:param>
		
		<xsl:variable name="inheritances" select="$class/Extends | $class/Implements"></xsl:variable>
		<xsl:for-each select="$inheritances">
			<xsl:variable name="item" select="key('classifier', current()/@idref)"></xsl:variable>
			<xsl:variable name="containsNode">
				<xsl:call-template name="searchFor">
					<xsl:with-param name="where" select="$thisNode"></xsl:with-param>
					<xsl:with-param name="what" select="$item"></xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="string-length($containsNode) = 0">
				<xsl:call-template name="InheritedMethods">
					<xsl:with-param name="class" select="$item"></xsl:with-param>
					<xsl:with-param name="thisNode" select="$thisNode | $item"></xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			
			<xsl:variable name="methods" select="$item/Method[not(@visibility='private')]"></xsl:variable>
			<xsl:if test="$methods">
				
				<!-- Heading -->
				<table border="1" cellpadding="3" cellspacing="0" width="100%">
				<tr class="TableSubHeader">
				<td>
				<b>
				
				<xsl:variable name="reff">
					<xsl:apply-templates select="$item" mode="HRefWithImgLoad"/>
				</xsl:variable>
				
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'Methods_inherited_from'"/>
					<!--xsl:with-param name="p1" select="$item/@type"/-->
					<xsl:with-param name="p1">
						<xsl:call-template name="getLocalizedClassType">
							<xsl:with-param name="type" select="$item/@type"/>
						</xsl:call-template>
					</xsl:with-param>
					<xsl:with-param name="p2" select="$reff"/>
				</xsl:call-template>
			
				<!--xsl:text> </xsl:text>					
				<xsl:apply-templates select="$item" mode="HRefWithImgLoad"/-->
				</b>
				</td>
				</tr>

				<!-- Contents -->
				<tr class="TableRow">
				<td><code>
				<xsl:for-each select="$methods">
					<xsl:sort select="@name"></xsl:sort>

					<xsl:apply-templates select="current()" mode="HRefWithImgLoad"/>

					<!-- xsl:if test="not(position()=last())" (didn't work when sorting)-->
						<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
					<!-- /xsl:if -->

				</xsl:for-each>
				</code></td>
				</tr>				

				</table>
				<p/>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
